;
;	GENERIC.CTL - Generic Control File for DZ80 V2
;
;  Command line options:
;
;	D - Generate comment field with address and data values.
;	B - Force binary source file.
;	H - Force hex source file.
;
;  Control codes allowed in the CTL file:
;
;	A - Address	Specifies that the word entry is the address of
;			something for which a label should be generated.
;	B - Byte binary	Eight bit binary data.
;	C - Code	Executable code.
;	I - Ignore	Treat as uninitialized space. Will not be dis-
;			assembled as code or anything else.
;	L - Label	Generate a label for an address.
;	S - Symbol	Generate a symbol for a value.
;	T - Text	ASCII text.
;	W - Word binary	Sixteen bit binary data.
;
;  Values may specify ranges, ie:
;
;	A 100-11f specifies a table of addresses starting at address
;		0x100 and continuing to address 0x11f.
;
;	T 100-120 specifies that addresses 0x100 through (and including)
;		address 0x120 contain ascii text data.
;
;  Exit codes:
;
;	0 - No error (good disassembly).
;	1 - File error (source file not found or disk full).
;	2 - Error in control file.
;
;
; labels for interrupt vectors
;
l 0	start
l 1234	nn
l 13	really_long_label_for_testing
l 55	n
l 6789	spurious_label
;
s 0d	CR
s 0a	LF
s 0	ZERO
s ff	ONES
s 5	n
s 45	spurious_symbol
;
; end of control file
;

